using System;
using System.Text.RegularExpressions;
using System.Reflection;
using System.Diagnostics;


namespace CSharpRecipes
{
	public class NumbersEnums
    {
        #region "1.1 Okrelanie przyblionej rwnoci pomidzy wartoci uamkow, a zmiennoprzecinkow"

// Wersja, w ktrej wykorzystano warto epsilon typu System.Double.Epsilon
public static bool IsApproximatelyEqualTo(double numerator,
                                          double denominator,
                                          double dblValue)
{
    return IsApproximatelyEqualTo(numerator, denominator, dblValue, double.Epsilon);
}

// Wersja,w ktrej mona wprowadzi warto epsilon
// innego typu ni System.Double.Epsilon
public static bool IsApproximatelyEqualTo(double numerator, 
                                          double denominator, 
                                          double dblValue,
                                          double epsilon)
{
    double difference = (numerator/denominator) - dblValue;

    if (Math.Abs(difference) < epsilon)
    {
         // Dobre przyblienie.
         return true;
    }
    else
    {
        // To NIE jest dobre przyblienie.
        return false;
    }
}


        // Wersja, w ktrej wykorzystano warto System.Single.Epsilon
        public static bool IsApproximatelyEqualTo(float numerator,
            float denominator,
            float fltValue)
        {
            return IsApproximatelyEqualTo(numerator, denominator, fltValue, float.Epsilon);
        }


        // Wersja, w ktrej mona wprowadzi warto epsilon innego typu ni System.Single.Epsilon value
        public static bool IsApproximatelyEqualTo(float numerator, 
			float denominator, 
			float fltValue,
			float epsilon)
		{
			float difference = (numerator/denominator) - fltValue;
			Console.WriteLine("rnica: " + difference);

			if (Math.Abs(difference) < epsilon)
			{
				// To jest dobre przyblienie
				return true;
			}
			else
			{
				// To NIE jest dobre przyblienie
				return false;
			}
		}
		#endregion

        #region "1.2 Konwersja stopni na radiany"
        public static double ConvertDegreesToRadians(double degrees)
        {
            double radians = (Math.PI / 180) * degrees;
            return (radians);
        }
        #endregion

        #region "1.3 Konwersja radianw na stopnie"
        public static double ConvertRadiansToDegrees(double radians)
		{
			double degrees = (180 / Math.PI) * radians;
			return (degrees);
		}
        #endregion

        #region "1.4 Zastosowanie operatora bitowej negacji do danych rnych typw"
        public static void TestBitwiseOp()
		{
			uint x = 0x00000001;
			uint XComp = ~x;
			Console.WriteLine("~x = " + ~x);

			sbyte B1 = sbyte.MinValue;	
			sbyte B2 = sbyte.MaxValue;
			Console.WriteLine("B1|B2 = " + (((byte)B1|(byte)B2)));

			ushort x2 = 0x00000001;		// Problem
			Console.WriteLine("~x2 = " + ~x2);

			byte y = 1;		// Problem
			//byte B = ~y;
			Console.WriteLine("~y = " + ~y);

			char x3 = (char)1;		// Problem
			Console.WriteLine("~x3 = " + ~x3);

			sbyte x5 = 1;
			Console.WriteLine("~x5 = " + ~x5);
			
			uint IntResult = (uint)~x;
			Console.WriteLine("IntResult = " + IntResult);
			
			byte ByteResult = (byte)~y;
			Console.WriteLine("ByteResult = " + ByteResult);
		}
        #endregion

        #region "1.5 Sprawdzenie, czy liczba jest parzysta, czy nieparzysta"
        public static bool IsEven(int intValue)
		{
            return ((intValue % 2) == 0);
		}

		public static bool IsOdd(int intValue)
		{
            return ((intValue % 2) == 1);
		}
        #endregion

        #region "1.6 Uzyskanie bardziej znaczcego i mniej znaczcego sowa liczby"
        public static void TestSignificance()
        {
            int number = 9000;
            short num = 25;
            Console.WriteLine(GetHighWord(number));
            Console.WriteLine(GetConvertHighWord(number));
            Console.WriteLine(GetLowWord(number));
            Console.WriteLine(GetConvertLowWord(number));
            Console.WriteLine(GetHighByte(num));
            Console.WriteLine(GetLowByte(num));
        }
        
        public static int GetHighWord(int value)
        {
            return (value & (0xFFFF << 16));
        }
        public static int GetConvertHighWord(int value)
        {
            return (value & Convert.ToInt32("11111111111111110000000000000000", 2));
        }

        public static int GetLowWord(int intValue)
        {
            return (intValue & 0xFFFF);
        }

        public static int GetConvertLowWord(int intValue)
        {
            return (intValue & Convert.ToInt32("11111111111111110000000000000000", 2));
        }
        
        public static short GetHighByte(short shortValue)
        {
            return (short)(shortValue & (0xFF << 8));
        }

        public static short GetLowByte(short shortValue)
        {
            return (short)(shortValue & (short)0xFF);
        }
        #endregion

        #region "1.7 Konwersja liczby z innego systemu liczbowego na dziesitny"
        public static void TestBase10()
		{
			string base2 = "11";
			string base8 = "17";
			string base10 = "110";
			string base16 = "11FF";

			Console.WriteLine("Convert.ToInt32(base2, 2) = " + 
				Convert.ToInt32(base2, 2));

			Console.WriteLine("Convert.ToInt32(base8, 8) = " + 
				Convert.ToInt32(base8, 8));

			Console.WriteLine("Convert.ToInt32(base10, 10) = " + 
				Convert.ToInt32(base10, 10));

			Console.WriteLine("Convert.ToInt32(base16, 16) = " + 
				Convert.ToInt32(base16, 16));
		}
        #endregion

        #region "1.8 Sprawdzenie, czy cig znakw reprezentuje prawidow liczb"
        public static void TestDetermineIfStrIsNum()
		{
			string IsNotNum = "111west";
			string IsNum = "  +111  ";
			string IsFloat = "  23.11  ";
			string IsExp = "  +23 e+11  ";

            int i = 0;
            float f = 0;

			Console.WriteLine(int.TryParse(IsNum, out i));		// 111		// 1.1 will not work here
			Console.WriteLine(float.TryParse(IsNum, out f));		// 111
			Console.WriteLine(float.TryParse(IsFloat, out f));	// 23.11
			//Console.WriteLine(float.Parse(IsExp));	// throws
			
		
			Console.WriteLine(IsInt(IsNum));		// True
            Console.WriteLine(IsInt(IsNotNum));		// False
            Console.WriteLine(IsInt(IsFloat));		// False
            Console.WriteLine(IsInt(IsExp));		// False
			Console.WriteLine();
			

            Console.WriteLine(IsDoubleFromTryParse(IsNum));		// True
            Console.WriteLine(IsDoubleFromTryParse(IsNotNum));		// False
            Console.WriteLine(IsDoubleFromTryParse(IsFloat));		// True
            Console.WriteLine(IsDoubleFromTryParse(IsExp));		// False
			Console.WriteLine();
		}
		
		
		public static bool IsInt(string str)
		{
			try
			{
				str = str.Trim();
				int foo = int.Parse(str);
				return (true);
			}
			catch (FormatException e)
			{
				Console.WriteLine("To nie jest warto typu integer: {0}", e.ToString());
				return (false);
			}
		}
		public static bool IsDoubleFromTryParse(string str)
		{
			double result = 0;
			return (double.TryParse(str, System.Globalization.NumberStyles.Float, System.Globalization.NumberFormatInfo.CurrentInfo, out result));
		}
		#endregion

        #region "1.9 Zaokrglanie wartoci zmiennoprzecinkowych"
        public static void TestRound()
		{
			int X = (int)Math.Round(2.5555);
			Console.WriteLine(X);
			Console.WriteLine(Math.Round(2.5555, 2));
			Console.WriteLine(Math.Round(2.444444,3));
			Console.WriteLine(Math.Round(2.555555555555555555555555555550001));
			Console.WriteLine(Math.Round(.5));
			Console.WriteLine(Math.Round(1.5));
			Console.WriteLine(Math.Round(2.5));
			Console.WriteLine(Math.Round(3.5));
			Console.WriteLine();
			
			Console.WriteLine(Math.Floor(.5));
			Console.WriteLine(Math.Floor(1.5));
			Console.WriteLine(Math.Floor(2.5));
			Console.WriteLine(Math.Floor(3.5));
			Console.WriteLine();
			
			Console.WriteLine(Math.Ceiling(.5));
			Console.WriteLine(Math.Ceiling(1.5));
			Console.WriteLine(Math.Ceiling(2.5));
			Console.WriteLine(Math.Ceiling(3.5));	
			Console.WriteLine();

			Console.WriteLine(RoundUp(.4));
			Console.WriteLine(RoundUp(.5));
			Console.WriteLine(RoundUp(.6));
			Console.WriteLine(RoundUp(1.4));
			Console.WriteLine(RoundUp(1.5));
			Console.WriteLine(RoundUp(1.6));
			Console.WriteLine(RoundUp(2.4));
			Console.WriteLine(RoundUp(2.5));
			Console.WriteLine(RoundUp(2.6));
			Console.WriteLine(RoundUp(3.4));
			Console.WriteLine(RoundUp(3.5));
			Console.WriteLine(RoundUp(3.6));
			Console.WriteLine();

			Console.WriteLine(RoundDown(.4));
			Console.WriteLine(RoundDown(.5));
			Console.WriteLine(RoundDown(.6));
			Console.WriteLine(RoundDown(1.4));
			Console.WriteLine(RoundDown(1.5));
			Console.WriteLine(RoundDown(1.6));
			Console.WriteLine(RoundDown(2.4));
			Console.WriteLine(RoundDown(2.5));
			Console.WriteLine(RoundDown(2.6));
			Console.WriteLine(RoundDown(3.4));
			Console.WriteLine(RoundDown(3.5));
			Console.WriteLine(RoundDown(3.6));
		}
		#endregion

        #region "1.10 Wybr algorytmu zaokrglania"
        public static double RoundUp(double valueToRound)
		{
//			double floorValue = Math.Floor(valueToRound);
//			if ((valueToRound - floorValue) >= .5)
//			{
//				return (floorValue + 1);
//			}
//			else
//			{
//				return (floorValue);
//			}

			return (Math.Floor(valueToRound + 0.5));
		}
		
		public static double RoundDown(double valueToRound)
		{
			double floorValue = Math.Floor(valueToRound);
			if ((valueToRound - floorValue) > .5)
			{
				return (floorValue + 1);
			}
			else
			{
				return (floorValue);
			}
		}
		#endregion

        #region "1.11 Zamiana stopni Celsjusza na Fahrenheita"
        public static double CtoF(double celsius)
		{
			return (((0.9/0.5) * celsius) + 32);
		}
		#endregion

        #region "1.12 Zamiana stopni Fahrenheita na Celsjusza"
        public static double FtoC(double fahrenheit)
		{
			return ((0.5/0.9) * (fahrenheit - 32));
		}
		#endregion

        #region "1.13 Bezpieczna konwersja liczb do mniejszego rozmiaru"
        public static void TestNarrowing()
        {
            // Deklaracja i zainicjowanie dwch zmiennych
            int sourceValue = 34000;
            short destinationValue = 0;

            // Sprawdzenie, czy konwersja wartoci sourceValue na typ short spowoduje utrat informacji
            if (sourceValue <= short.MaxValue && sourceValue >= short.MinValue)
            {
                destinationValue = (short)sourceValue;
            }
            else
            {
                // Poinformowanie aplikacji o utracie informacji
            }

            long lhs = 34000;
            long rhs = long.MaxValue;
            UseChecked(lhs, rhs);
        }

        public static void UseChecked(long lhs, long rhs)
        {
            int result = 0;

            try
            {
                result = checked((int)(lhs + rhs));
            }
            catch (OverflowException e)
            {
                // Obsuga wyjtku przepenienia.
                Console.WriteLine(e);
            }
        }
        #endregion

        #region "1.14 Wyznaczanie dugoci dowolnego z trzech bokw trjkta prostoktnego"
        public static void TestTriangle()
		{
            double theta = 30;
            double xSide = 5;
            double ySide = 7;
            double hypotenuse = 0;
            double oppositeSide = 5;
            double adjacentSide = 0;
			
			hypotenuse   = oppositeSide / Math.Sin(theta);
			oppositeSide = Math.Sin(theta) * hypotenuse;
			adjacentSide = Math.Cos(theta) * hypotenuse;
			oppositeSide = Math.Tan(theta) * adjacentSide;
			adjacentSide = oppositeSide / Math.Tan(theta);
			hypotenuse   = adjacentSide / Math.Cos(theta);
			hypotenuse = Math.Sqrt(Math.Pow(xSide, 2) + Math.Pow(ySide, 2));
		}
		#endregion

        #region "1.15 Obliczanie ktw trjkta prostoktnego"
        public static void TestAnglesRightTriangle()
		{
            double theta = 30;
            double hypotenuse;
            double oppositeSide = 5;
            double adjacentSide;

            hypotenuse   = oppositeSide / Math.Sin(theta);
            adjacentSide = Math.Cos(theta) * hypotenuse;
            // Poniszy kod oblicza kt Theta i zwraca warto w radianach
            theta = Math.Atan(oppositeSide / adjacentSide);
            theta = Math.Acos(adjacentSide / hypotenuse);
            theta = Math.Asin(oppositeSide / hypotenuse);
			
            // Aby uzyska warto w stopniach, mona wykorzysta poniszy kod:
            theta = Math.Atan(oppositeSide / adjacentSide) * (180 / Math.PI);
            theta = Math.Acos(adjacentSide / hypotenuse) * (180 / Math.PI);
            theta = Math.Asin(oppositeSide / hypotenuse) * (180 / Math.PI);
        }
		#endregion

        #region "1.16 Wywietlanie wartoci typu wyliczeniowego w postaci tekstowej"
        public static void TestDisplayEnumValue()
		{
			Console.WriteLine(Shape.Circle.ToString());
			Console.WriteLine(Shape.Circle.ToString("G"));
			Console.WriteLine(Shape.Circle.ToString("D"));
			Console.WriteLine(Shape.Circle.ToString("F"));
			Console.WriteLine(Shape.Circle.ToString("X"));

			Console.WriteLine();

			Shape shapeStyle = Shape.Cylinder;
			Console.WriteLine(shapeStyle.ToString());
			Console.WriteLine(shapeStyle.ToString("G"));
			Console.WriteLine(shapeStyle.ToString("D"));
			Console.WriteLine(shapeStyle.ToString("F"));
			Console.WriteLine(shapeStyle.ToString("X"));

			Console.WriteLine();

			shapeStyle = Shape.Circle | Shape.Cylinder;
			Console.WriteLine(shapeStyle.ToString());
			Console.WriteLine(shapeStyle.ToString("G"));
			Console.WriteLine(shapeStyle.ToString("D"));
			Console.WriteLine(shapeStyle.ToString("F"));
			Console.WriteLine(shapeStyle.ToString("X"));

		}
		#endregion

        #region "1.17 Konwersja zwykego tekstu na odpowiedniki w postaci wartoci typu wyliczeniowego"
        public static void TestConvertingEnums()
		{
			try
			{
				Language proj1Language = (Language)Enum.Parse(typeof(Language), "VBNET");
				//Language proj2Language = (Language)Enum.Parse(typeof(Language), "UnDefined");

                proj1Language = (Language)Enum.Parse(typeof(Language),"1");
                proj1Language = (Language)Enum.Parse(typeof(Language), "CSharp, VBNET");
			}
			catch (ArgumentException e)
			{
				// Obsuga nieprawidowej wartoci tekstowej (na przykad cigu "UnDefined")
				Console.WriteLine(e);
			}
		}
		#endregion

        #region "1.18 Sprawdzanie poprawnoci wartoci typu wyliczeniowego"
        public static void HandleEnum(Language language)
		{
            if (CheckLanguageEnumValue(language))
			{
				// Wykorzystanie jzyka
				Console.WriteLine("OK");
			}
			else
			{
				// Obsuga nieprawidowej wartoci typu wyliczeniowego
				Console.WriteLine("WARTO NIEPRAWIDOWA");
			}
		}

        public static bool CheckLanguageEnumValue(Language language)
        {
            switch (language)
            {
                // Naley wymieni wszystkie prawidowe wartoci typu wyliczeniowego.
                // Oznacza to, e metoda bdzie akceptowaa tylko te wartoci typu, ktre
                // wymienimy. Inne wartoci bd nieprawidowe.
                case Language.CSharp:
                case Language.Other:
                case Language.VB6:
                case Language.VBNET:
                    break;
                default:
                    Debug.Assert(false, language + " nie jest prawidow wartoci typu wyliczeniowego akceptowan przez procedur.");
                    return false;
            }
            return true;
        }

		#endregion

        #region "1.19 Sprawdzanie poprawnoci typu wyliczeniowego z atrybutem Flags"
        public static bool HandleFlagsEnum(Language language)
        {
            if ((language>0) && ((language & Language.All) == language))
            {
                // Wykorzystanie jzyka
                Console.WriteLine("OK");
                return (true);
            }
            else
            {
                // Obsuga nieprawidowej wartoci typu wyliczeniowego
                Console.WriteLine("WARTO NIEPRAWIDOWA");
                return (false);
            }
        }

		public static bool HandleFlagsEnum(int language)
		{
			if ((language>0) && ((language & (int)Language.All) == language))
			{
				// Wykorzystanie jzyka
				Console.WriteLine("OK");
				return (true);
			}
			else
			{
				// Obsuga nieprawidowej wartoci typu 
				Console.WriteLine("WARTO NIEPRAWIDOWA");
				return (false);
			}
		}
		#endregion

        #region "1.20 Zastosowanie elementw typu wyliczeniowego w masce bitowej"
        // Opis mona znale w tekcie ksiki  - receptura 1.20.
		#endregion

        #region "1.21 Sprawdzanie, czy ustawiono jedn bd kilka flag w danych typw wyliczeniowych"
        //Opis mona znale w tekcie ksiki  - receptura 1.21.

		[Flags]
		public enum Language_1_21
		{
			CSharp = 0x0001, VBNET = 0x0002, VB6 = 0x0004, Cpp = 0x0008,
			AllLanguagesExceptCSharp = VBNET | VB6 | Cpp
		}

		public static void TestEnumFlags()
		{
			Language_1_21 lang = Language_1_21.CSharp | Language_1_21.VBNET;

			if ((lang & Language_1_21.CSharp) == Language_1_21.CSharp)
			{
                Console.WriteLine("W zmiennej lang wczono co najmniej warto Language.CSharp");
			}

			if (lang == Language_1_21.CSharp)
			{
                Console.WriteLine("W zmiennej lang wczono wycznie warto Language.CSharp");
			}

			if ((lang > 0) && ((lang & (Language_1_21.CSharp | Language_1_21.VBNET)) ==
			   (Language_1_21.CSharp | Language_1_21.VBNET)))
			{
                Console.WriteLine(" W zmiennej lang wczono co najmniej elementy Language.CSharp oraz Language.VBNET");
			}

			if ((lang > 0) && ((lang | (Language_1_21.CSharp | Language_1_21.VBNET)) ==
			   (Language_1_21.CSharp | Language_1_21.VBNET)))
			{
                Console.WriteLine("W zmiennej lang wczono wycznie elementy Language.CSharp oraz Language.VBNET.");
			}

			lang = Language_1_21.CSharp;
			if ((lang & Language_1_21.CSharp) == Language_1_21.CSharp)
			{
                  //Language.CSharp      0001
                  //lang                 0001
                  //Wynik operacji AND   0001


				Console.WriteLine("Dziki operacji AND znaleziono warto CSharp");
			}

			lang = Language_1_21.CSharp;
			if ((lang > 0) && (Language_1_21.CSharp == (lang | Language_1_21.CSharp)))
			{
                //  Dziki zastosowaniu operacji OR znaleziono warto CSharp
			}

			lang = Language_1_21.CSharp | Language_1_21.VB6 | Language_1_21.Cpp;
			if ((lang > 0) && (Language_1_21.CSharp == (lang | Language_1_21.CSharp)))
			{
                //  Dziki zastosowaniu operacji OR znaleziono warto CSharp
			}

			lang = Language_1_21.VBNET | Language_1_21.VB6 | Language_1_21.Cpp;
			if ((lang > 0) && (Language_1_21.CSharp == (lang | Language_1_21.CSharp)))
			{
                //  Dziki zastosowaniu operacji OR znaleziono warto CSharp
			}

			lang = Language_1_21.VBNET;
			if ((lang & Language_1_21.CSharp) == Language_1_21.CSharp)
			{
				//Language_1_21.CSharp      0001
				//lang                      0010
				//Wynik operacji AND        0000
				Console.WriteLine("W operacji AND znaleziono warto CSharp");
			}

			lang = Language_1_21.CSharp;

			if (lang == Language_1_21.CSharp)
			{
				//Language_1_21.CSharp      0001
				//lang                      0001
				//Wynik operacji OR         0001

			}

			if ((lang > 0) && (Language_1_21.CSharp == (lang | Language_1_21.CSharp)))
			{
			}

			lang = Language_1_21.CSharp | Language_1_21.Cpp | Language_1_21.VB6;

			if (lang == Language_1_21.CSharp)
			{
				//Language_1_21.CSharp      0001
				//lang                      1101
				//wynik operacji OR         1101
			}

			lang = Language_1_21.CSharp | Language_1_21.VBNET;
			if ((lang > 0) && ((lang & (Language_1_21.CSharp | Language_1_21.VBNET)) ==
			   (Language_1_21.CSharp | Language_1_21.VBNET)))
			{
				//mona sprawdza kilka bitw jednoczenie.
				Console.WriteLine("Znaleziono wyacznie wartoci CSharp i VBNET");
			}

			// sprawdzenie po dodaniu jzyka Cpp
			lang = Language_1_21.CSharp | Language_1_21.VBNET | Language_1_21.Cpp;
			if ((lang > 0) && ((lang & (Language_1_21.CSharp | Language_1_21.VBNET)) ==
			   (Language_1_21.CSharp | Language_1_21.VBNET)))
			{
				//mona sprawdza kilka bitw, by dowiedzie si, czy co najmniej one s wczone (niezalenie od pozostaych).
				Console.WriteLine("Znaleziono co najmniej wartoci CSharp i VBNET ");
			}

			lang = Language_1_21.CSharp | Language_1_21.VBNET;
			if ((lang > 0) && ((lang | (Language_1_21.CSharp | Language_1_21.VBNET)) ==
			   (Language_1_21.CSharp | Language_1_21.VBNET)))
			{
				//mona sprawdzi, czy co najmniej te bity s wczone.
				Console.WriteLine("Znaleziono CSharp lub VBNET");
			}

			lang = Language_1_21.CSharp | Language_1_21.VBNET | Language_1_21.Cpp;
			if ((lang > 0) && ((lang | (Language_1_21.CSharp | Language_1_21.VBNET)) ==
			   (Language_1_21.CSharp | Language_1_21.VBNET)))
			{
				//mona sprawdzi, czy co najmniej te bity s wczone.
				Console.WriteLine("Znaleziono CSharp lub VBNET");
			}

			if ((lang > 0)&&(lang | Language_1_21.AllLanguagesExceptCSharp) ==
				Language_1_21.AllLanguagesExceptCSharp)
			{
				Console.WriteLine("Nie wprowadzono tylko CSharp");
			}

		}
		#endregion

        #region "1.22 Wyznaczanie czci cakowitej zmiennej typu decimal lub double"
        public static void TestTruncate()
		{
			decimal pi = (decimal)System.Math.PI;
			decimal decRet = System.Math.Truncate(pi);
			double trouble = 5.555;
			double dblRet = System.Math.Truncate(trouble);
		}
		#endregion
	}
}

#region "Zdefiniowane typy wyliczeniowe"
[Flags]
public enum Shape
{
	Square = 0, Circle = 1, Cylinder = 2, Octagon = 4
}


public enum Language
{
	Other = 0, CSharp = 1, VBNET = 2, VB6 = 3,
	All = (Other | CSharp | VBNET | VB6)
}
#endregion
